/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_60;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.util.Strings;

public class FabricModConstructor {
    private FabricModConstructor(ModConstructor constructor) {
        constructor.onConstructMod();
    }

    private void registerEntityAttribute(class_1299<? extends class_1309> type, class_5132.class_5133 builder) {
        if (class_5135.method_26875(type)) {
            throw new IllegalStateException("Duplicate DefaultAttributes entry: " + type);
        }
        FabricDefaultAttributeRegistry.register(type, (class_5132.class_5133)builder);
    }

    private void modifyEntityAttribute(class_1299<? extends class_1309> type, class_1320 attribute, double attributeValue) {
        class_5132 supplier = class_5135.method_26873(type);
        Map<class_1320, Double> attributeToBaseValueMap = class_2378.field_23781.method_10220().filter(arg_0 -> ((class_5132)supplier).method_27310(arg_0)).map(attribute1 -> supplier.method_26863(instance -> {}, attribute1)).filter(Objects::nonNull).collect(Collectors.toMap(class_1324::method_6198, class_1324::method_6201));
        attributeToBaseValueMap.put(attribute, attributeValue);
        class_5132.class_5133 builder = class_5132.method_26861();
        attributeToBaseValueMap.forEach((arg_0, arg_1) -> ((class_5132.class_5133)builder).method_26868(arg_0, arg_1));
        FabricDefaultAttributeRegistry.register(type, (class_5132.class_5133)builder);
    }

    private void registerFuelItem(class_1792 item, int burnTime) {
        if (burnTime > 0 && item != null) {
            FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
        }
    }

    private ModConstructor.LootTablesReplaceContext getLootTablesReplaceContext(class_60 lootManager, class_2960 id, class_52 original, final MutableObject<class_52> replacement) {
        return new ModConstructor.LootTablesReplaceContext(lootManager, id, original){

            @Override
            public void setLootTable(class_52 table) {
                replacement.setValue((Object)table);
            }
        };
    }

    private ModConstructor.LootTablesModifyContext getLootTablesModifyContext(class_60 lootManager, class_2960 id, final class_52.class_53 tableBuilder) {
        return new ModConstructor.LootTablesModifyContext(lootManager, id){

            @Override
            public void addLootPool(class_55 pool) {
                tableBuilder.pool(pool);
            }

            @Override
            public boolean removeLootPool(int index) {
                MutableInt counter = new MutableInt();
                MutableBoolean result = new MutableBoolean();
                tableBuilder.modifyPools(builder -> {
                    if (index == counter.getAndIncrement()) {
                        builder.method_352((class_5658)class_44.method_32448((float)0.0f));
                        builder.method_35509((class_5658)class_44.method_32448((float)0.0f));
                        result.setTrue();
                    }
                });
                return result.booleanValue();
            }
        };
    }

    public static void construct(String modId, ModConstructor constructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("modId cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing common components for mod {}", (Object)modId);
        FabricModConstructor fabricModConstructor = new FabricModConstructor(constructor);
        constructor.onCommonSetup();
        constructor.onRegisterSpawnPlacements(class_1317::method_20637);
        constructor.onEntityAttributeCreation(fabricModConstructor::registerEntityAttribute);
        constructor.onEntityAttributeModification(fabricModConstructor::modifyEntityAttribute);
        constructor.onRegisterFuelBurnTimes(fabricModConstructor::registerFuelItem);
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> constructor.onRegisterCommands(new ModConstructor.RegisterCommandsContext((CommandDispatcher<class_2168>)dispatcher, context, environment)));
        LootTableEvents.REPLACE.register((resourceManager, lootManager, id, original, source) -> {
            if (source != LootTableSource.DATA_PACK) {
                MutableObject replacement = new MutableObject();
                constructor.onLootTableReplacement(fabricModConstructor.getLootTablesReplaceContext(lootManager, id, original, (MutableObject<class_52>)replacement));
                return (class_52)replacement.getValue();
            }
            return null;
        });
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (source != LootTableSource.DATA_PACK) {
                constructor.onLootTableModification(fabricModConstructor.getLootTablesModifyContext(lootManager, id, tableBuilder));
            }
        });
    }
}

